/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.api.mobbase;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public interface ImmortalersMob {
    public float getAttackProportion();

    public int getDamageDivisor();

    public boolean shouldBlastDamageHurt(LivingEntity var1);

    default public void performBlastAttack(LivingEntity attacker, Vec3 pos, float range, DamageSource source, float damage, boolean isExplosion, boolean bypassCooldown, boolean isCircular) {
        if (!attacker.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)attacker.m_9236_();
            if (isExplosion) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123813_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 10, 0.5, 0.5, 0.5, 0.1);
            }
            this.doBlastDamage(this.getTargetsOfBlastDamage(attacker, pos, range, isCircular), pos, range, source, damage, true, bypassCooldown);
        }
    }

    default public List<LivingEntity> getTargetsOfBlastDamage(LivingEntity attacker, Vec3 pos, float range, boolean isCircular) {
        if (!attacker.m_9236_().f_46443_) {
            ServerLevel serverLevel = (ServerLevel)attacker.m_9236_();
            AABB boundingBox = new AABB(pos.f_82479_ - (double)range, pos.f_82480_ - (double)range, pos.f_82481_ - (double)range, pos.f_82479_ + (double)range, pos.f_82480_ + (double)range, pos.f_82481_ + (double)range);
            List entitiesInRange = serverLevel.m_6443_(LivingEntity.class, boundingBox, LivingEntity::m_6084_);
            if (isCircular) {
                entitiesInRange.removeIf(entity -> entity.m_20238_(pos) > (double)(range * range));
            }
            return entitiesInRange;
        }
        return new ArrayList<LivingEntity>();
    }

    default public void doBlastDamage(List<LivingEntity> targets, Vec3 pos, float range, DamageSource source, float damage, boolean isExplosion, boolean bypassCooldown) {
        for (LivingEntity target : targets) {
            if (!this.shouldBlastDamageHurt(target)) continue;
            if (bypassCooldown) {
                target.f_19802_ = 0;
            }
            if (isExplosion) {
                target.m_6469_(source, (float)((double)(damage * damage) / target.m_20238_(pos)));
            } else {
                target.m_6469_(source, damage);
            }
            double knockbackX = (target.m_20185_() - pos.f_82479_) * 0.1;
            double knockbackY = (target.m_20186_() - pos.f_82480_ > 0.0 ? (double)range - (target.m_20186_() - pos.f_82480_) : (double)(range * -1.0f) - (target.m_20186_() - pos.f_82480_)) * 0.1;
            double knockbackZ = (target.m_20189_() - pos.f_82481_) * 0.1;
            target.m_20334_(knockbackX, knockbackY, knockbackZ);
        }
    }
}

